using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class uc_PM25CalculationOptionsA : ucBase
    {
        public uc_PM25CalculationOptionsA()
        {
            InitializeComponent();

            #region Language added by Yangwenwei
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }

        private void uc_PM25CalculationOptionsA_Load(object sender, EventArgs e)
        {
            try
            {
                pnlRequiredDV.Visible = false;
                //cboRequiredA.Items.Add("None selected");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void rbtnOfficialA_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                nudownMinDaysA.Enabled = false;
                nudownMinQuarterA.Enabled = false;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void rbtnCustomA_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                nudownMinDaysA.Enabled = true;
                nudownMinQuarterA.Enabled = true;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnSelect_Click(object sender, EventArgs e)
        {
            try
            {
                pnlRequiredDV.Visible = true;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            try
            {
                string strDV = "";
                StringBuilder builder = new StringBuilder();
                this.pnlRequiredDV.Visible = false;
                for (int i = 0; i < this.clboRequiredDV.Items.Count; i++)
                {
                    if (this.clboRequiredDV.GetItemChecked(i))
                    {
                        builder.Append(clboRequiredDV.Items[i].ToString() + ",");
                    }
                }
                strDV = builder.ToString();
                if (strDV == "" || strDV == null)
                {
                    strDV = "None selected";
                }
                else
                {
                    strDV = strDV.Substring(0, strDV.Length - 1);
                }
                txtRequiredA.Text = strDV;
                if (txtRequiredA.Text != "None selected")
                {
                    if (Convert.ToInt32(txtRequiredA.Text.Substring(0, 4)) < Convert.ToInt32(cboStartYearA.Text)
                        || Convert.ToInt32(txtRequiredA.Text.Remove(0, txtRequiredA.Text.Length - 4)) > Convert.ToInt32(cboEndYearA.Text))
                        MessageBox.Show(LanguageOld.Translate("Required Design Values is not correct!"));
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblMonitorDataYears_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_1_6_pm2_5_calculation_option.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboEndYearA_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboEndYearA.Text) < Convert.ToInt32(cboStartYearA.Text))
                    cboStartYearA.Text = cboEndYearA.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboStartYearA_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboEndYearA.Text) < Convert.ToInt32(cboStartYearA.Text))
                    cboEndYearA.Text = cboStartYearA.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
